//
// (c) 2020 wesolutions GmbH
// All rights reserved
//

import QtQuick 2.12
import QtGraphicalEffects 1.0

import wesual.Ui 1.0

import wesual.Ui.Private 1.0

MouseArea {
    id : uiInfoTip

    default property Component contentDelegate

    property int contentMargin  : 10
    property int verticalOffset : 0
    property int horizontalOffset : 0

    property bool flipped : false

    readonly property bool shown : popupAnchor.popupVisible

    function show() {
        popupAnchor.show();
    }

    function hide() {
        popupAnchor.hide();
    }

    implicitWidth  : 24
    implicitHeight : 24
    hoverEnabled   : true
    acceptedButtons : Qt.NoButton

    onEnabledChanged : {
        if (!enabled) {
            popupAnchor.hide();
        }
    }

    Timer {
        id : showTimer

        interval : 300
        repeat   : false
        running  : uiInfoTip.containsMouse
    }

    UiPopupAnchor {
        id : popupAnchor

        popupVisible : !showTimer.running && uiInfoTip.containsMouse

        readonly property int popupHeight : popupItem ? popupItem.height : 0
        readonly property int popupWidth  : popupItem ? popupItem.width  : 0

        anchors.centerIn : parent
        anchors.horizontalCenterOffset : uiInfoTip.horizontalOffset

        states : [
            State {
                name : "shifted-and-flipped"
                when : popupAnchor.popupItem &&
                     (popupAnchor.distanceTop - popupAnchor.popupHeight) < 20 &&
                     (popupAnchor.distanceRight - popupAnchor.popupWidth) < 20
            },
            State {
                name : "shifted"
                when : popupAnchor.popupItem &&
                       (popupAnchor.distanceRight - popupAnchor.popupWidth) < 20
            },
            State {
                name : "flipped"
                when : uiInfoTip.flipped || (popupAnchor.popupItem &&
                       (popupAnchor.distanceTop - popupAnchor.popupHeight) < 20)
            }
        ]

        popup : Item {
            id : infoTipPopup

            property int anchorPos : 20
            property int padding   : 24

            implicitWidth  : content.implicitWidth  + padding + 2 * contentMargin
            implicitHeight : content.implicitHeight + padding + 2 * contentMargin

            anchors {
                bottom       : parent.top
                left         : parent.horizontalCenter
                leftMargin   : -32
                rightMargin  : -32

                bottomMargin : -6 + verticalOffset
                topMargin    : -6 + verticalOffset
            }

            state : popupAnchor.state

            states : [
                State {
                    name : "shifted-and-flipped"

                    AnchorChanges {
                        target : infoTipPopup
                        anchors {
                            bottom : undefined
                            top    : parent.bottom
                            left   : undefined
                            right  : parent.horizontalCenter
                        }
                    }
                    PropertyChanges {
                        target : peak
                        y      : 1 - peak.height
                        x      : peak.parent.width -
                                 infoTipPopup.anchorPos -
                                 peak.width / 2
                        source : "qrc:/ui/images/infotip-peak-up.png"
                    }
                },
                State {
                    name : "shifted"

                    AnchorChanges {
                        target : infoTipPopup
                        anchors {
                            left  : undefined
                            right : parent.horizontalCenter
                        }
                    }
                    PropertyChanges {
                        target : peak
                        x      : peak.parent.width -
                                 infoTipPopup.anchorPos -
                                 peak.width / 2
                    }
                },
                State {
                    name : "flipped"

                    AnchorChanges {
                        target : infoTipPopup
                        anchors {
                            bottom : undefined
                            top    : parent.bottom
                        }
                    }
                    PropertyChanges {
                        target : peak
                        y      : 1 - peak.height
                        source : "qrc:/ui/images/infotip-peak-up.png"
                    }
                }
            ]

            Item {
                id : background

                anchors.fill : parent
                opacity      : 0

                states : State {
                    name : "visible"
                    when : popupAnchor.popupVisible

                    PropertyChanges {
                        target  : background
                        opacity : 1
                    }
                    PropertyChanges {
                        target  : content
                        opacity : 1
                    }
                    PropertyChanges {
                        target  : shadow
                        opacity : 1
                    }
                }

                transitions : Transition {
                    NumberAnimation {
                        duration : 150
                        property : "opacity"
                    }
                }

                Rectangle {
                    x      : content.x - contentMargin
                    y      : content.y - contentMargin
                    width  : content.width  + 2 * contentMargin
                    height : content.height + 2 * contentMargin

                    border {
                        width : 1
                        color : UiColors.getColor(UiColors.ControlGrey20)
                    }

                    Image {
                        id : peak

                        source : "qrc:/ui/images/infotip-peak-down.png"
                        y      : parent.height - 1
                        x      : Math.round(anchorPos - width / 2)
                        smooth : false
                    }
                }
            }

            UiLoader {
                id : content

                sourceComponent  : uiInfoTip.contentDelegate
                anchors.centerIn : background
                opacity          : 0
            }

            DropShadow {
                id : shadow

                anchors.fill : background
                source       : background
                z            : -1

                verticalOffset : 4
                samples        : 16
                radius         : 10
                color          : "#1F000000"
                opacity        : 0
            }
        }
    }
}
